(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	jQuery( document ).ready(function() {
		if (jQuery('#webexpert_skroutz_smart_cart_user_id').length)
			jQuery('#webexpert_skroutz_smart_cart_user_id').select2({width:'350px'});

		if (jQuery('#webexpert_skroutz_smart_cart_variation_attributes').length)
			jQuery('#webexpert_skroutz_smart_cart_variation_attributes').select2({width:'350px'});

		jQuery('#webexpert_skroutz_smart_cart_grab_order').on('click',function(e){
			e.preventDefault();
			var $this=$(this);
			jQuery.ajax({
				type : "post",
				dataType : "json",
				url : ajax_object.ajax_url,
				data : {action: "webexpert_skroutz_smart_cart_grab_order",order_id: jQuery('#webexpert_skroutz_smart_cart_grab_order_id').val()},
				success: function(response) {
					if (response.success) {
						alert($this.data('success')+response.order_id);
					}else {
						alert($this.data('fail'));
					}
				}
			});
		})

		jQuery('#smart_cart_accept_order').on('click',function(e){
			e.preventDefault();
			var $this=$(this);
			jQuery.ajax({
				type : "post",
				dataType : "json",
				url : ajax_object.ajax_url,
				data : {action: "webexpert_skroutz_smart_cart_accept_order", pickup_location: jQuery('#smart_cart_order_pickup_location').val(), pickup_window: jQuery('#smart_cart_order_pickup_window').val(), order_id:$this.data('order')},
				success: function(response) {
					if (response.success===1) {
						alert("Order accepted.");
						location.reload();
					}else {
						alert(response.errors);
					}
				}
			});
		});

		jQuery('#smart_cart_reject_toggle').on('click',function(e){
			jQuery('#smart_cart_order_reject_container').slideToggle();
		});

		jQuery('#smart_cart_reject_order').on('click',function(e){
			e.preventDefault();
			var $this=$(this);

			jQuery.ajax({
				type : "post",
				dataType : "json",
				url : ajax_object.ajax_url,
				data : {action: "webexpert_skroutz_smart_cart_reject_order", reject_reason: jQuery('#smart_cart_order_reject_reason').val(), reject_reason_other: jQuery('#smart_cart_order_reject_reason_other').val(), order_id:$this.data('order'), line_numbers: jQuery('#smart_cart_order_line_numbers').val()},
				success: function(response) {
					console.log(response);
					if (response.success===1) {
						alert("Order accepted.");
						location.reload();
					}else {
						alert(response.errors);
					}
				}
			});
		});

	});

})( jQuery );
