<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.webexpert.gr/
 * @since             1.0.0
 * @package           Webexpert_Woocommerce_Skroutz_Smart_Cart
 *
 * @wordpress-plugin
 * Plugin Name:       WooCommerce Skroutz Smart Cart
 * Plugin URI:        https://www.webexpert.gr/plugin/woocommerce/skroutz-bestprice-glami/woocommerce-skroutz-smart-cart
 * Description:       Web Expert WooCommerce Skroutz Smart Cart is a tool that automates the order management from Skroutz Smart Cart to WooCommerce.
 * Version:           1.0.22
 * Requires at least: 4.0
 * Requires PHP:      7.0
 * Author:            Web Expert
 * Author URI:        https://www.webexpert.gr/
 * License: Web Expert license
 * Text Domain:       webexpert-woocommerce-skroutz-smart-cart
 * Domain Path:       /languages
 * WC requires at least: 3.0
 * WC tested up to: 6.8.0
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
define( 'WEBEXPERT_WOOCOMMERCE_SKROUTZ_SMART_CART_VERSION', '1.0.22' );

use Automattic\WooCommerce\Admin\Features\Navigation\Menu;

require plugin_dir_path( __FILE__ ).'includes/update/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'https://www.webexpert.gr/plugins/updates/?action=get_metadata&slug=webexpert-woocommerce-skroutz-smart-cart',
	__FILE__,
	'webexpert-woocommerce-skroutz-smart-cart'
);
//Add the license key to query arguments.
$myUpdateChecker->addQueryArgFilter('webexpert_woocommerce_smart_cart_update_checks');
function webexpert_woocommerce_smart_cart_update_checks($queryArgs) {
	$license = get_option('webexpert_skroutz_smart_cart_license_key');
	$domain = get_bloginfo('url');
	$parse = parse_url($domain);
	$domain = $parse['scheme'].'://'.$parse['host'];
	if ( !empty($license) ) {
		$queryArgs['license_key'] = $license;
	}
	if ( !empty($domain) ) {
		$queryArgs['domain'] = $domain;
	}
	return $queryArgs;
}

register_activation_hook( __FILE__, 'license_check' );
function license_check(){
	$license=get_option('webexpert_skroutz_smart_cart_license_key',false);
	if ($license===false) {
		$url='https://www.webexpert.gr/plugins/updates/?action=get_metadata&slug=webexpert-woocommerce-skroutz-smart-cart&license_key='.get_option('webexpert_skroutz_smart_cart_license_key').'&domain='.get_bloginfo('url');
		$request = wp_remote_get($url);
		$response = wp_remote_retrieve_body( $request );
		$s = json_decode($response);
		if (isset($s->download_url)) {
			update_option('webexpert_skroutz_smart_cart_license_key',true);
		}else {
			delete_option('webexpert_skroutz_smart_cart_license_key');
		}
	}
}

add_action( 'admin_menu', 'register_navigation_items_for_wc_admin_smart_cart' );
function register_navigation_items_for_wc_admin_smart_cart() {
	if (
		! class_exists( '\Automattic\WooCommerce\Admin\Features\Navigation\Menu' ) ||
		! class_exists( '\Automattic\WooCommerce\Admin\Features\Navigation\Screen' )
	) {
		return;
	}
	Menu::add_plugin_item(
		array(
			'id'         => 'webexpert-woocommerce-skroutz-smart-cart',
			'title'      => __( 'Skroutz Smart Cart', 'webexpert-woocommerce-skroutz-smart-cart' ),
			'capability'    => 'manage_woocommerce',
			'url'        => 'skroutz-smart-cart'
		)
	);
}
add_action('admin_menu', 'webexpert_skroutz_smart_cart_options_page');
function webexpert_skroutz_smart_cart_options_page()
{
	$request = wp_remote_get(plugin_dir_url(__FILE__).'assets/webexpert-icon.svg');
	$logo = wp_remote_retrieve_body( $request );
	if ( empty ( $GLOBALS['admin_page_hooks']['webexpert_plugins'] ) )
        add_menu_page('Web Expert Plugins','Web Expert','manage_woocommerce','webexpert_plugins','webexpert_skroutz_smart_cart_settings_main_menu','data:image/svg+xml;base64,' . base64_encode($logo),20);
    add_submenu_page('webexpert_plugins',__( 'Skroutz Smart Cart', 'webexpert-woocommerce-skroutz-smart-cart' ), __( 'Skroutz Smart Cart', 'webexpert-woocommerce-skroutz-smart-cart' ),'manage_woocommerce','skroutz-smart-cart','webexpert_skroutz_smart_cart_options_page_html'
    );
    remove_submenu_page('webexpert_plugins','webexpert_plugins');
}
add_action( 'admin_init', 'webexpert_skroutz_smart_cart_settings' );
function webexpert_skroutz_smart_cart_settings() {
    register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_prefered_payment_gateway' );
    register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_prefered_shipping_method' );
    register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_user_id' );
    register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_billing_email' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_debug' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_special_id' );
    register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_email' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_license_key' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_variation_attributes' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_api_token' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_unique_id' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_manage_orders' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_auto_accept_orders' );
	register_setting( 'webexpert-skroutz-smart-cart-group', 'webexpert_skroutz_smart_cart_auto_accept_orders_pickup_window' );
}

function webexpert_skroutz_smart_cart_settings_main_menu() {
    if (!current_user_can('manage_woocommerce')) {
        return;
    }
    ?>
    <div class="wrap">
        <h1><?= esc_html(get_admin_page_title()); ?></h1>
        <p>Ευχαριστούμε που επιλέγε την Web Expert.</p>
    </div>
    <?php
}
function webexpert_skroutz_smart_cart_options_page_html()
{
    if (!current_user_can('manage_woocommerce')) {
        return;
    }
	$attribute_taxonomies =  wc_get_attribute_taxonomies();
	$attributes_listed=array_column($attribute_taxonomies,'attribute_name');
	$attributes_listed=array_map(function($val) { return "pa_".$val;} , $attributes_listed);
	$attributes_listed=array_merge($attributes_listed,['product_type','product_visibility','product_cat','product_tag','product_shipping_class']);
	$custom_taxonomies = get_object_taxonomies('product', 'objects');
	$variation_attributes=get_option('webexpert_skroutz_smart_cart_variation_attributes');
	foreach ($custom_taxonomies as $k=>$taxonomy) {
		if (in_array($taxonomy->name,$attributes_listed)|| in_array("pa_".$taxonomy->name,$attributes_listed)) {
			unset($custom_taxonomies[$k]);
		}
	}
    ?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <h2><?php _e('Settings','webexpert-woocommerce-skroutz-smart-cart');?></h2>
        <p><?php _e('In order to be able to use the webhook, a webhook URL should be registered by the merchant from within Smart Cart settings page in merchant\'s panel (Merchants > Services > Smart Cart).','webexpert-woocommerce-skroutz-smart-cart');?></p>
        <p><?php _e('Webhook');?>: <code><?php echo rtrim(get_rest_url(null,'/wc/v3/smart_cart'),'/');?></code>
        <form action="options.php" method="post">
            <?php
            settings_fields('webexpert-skroutz-smart-cart-group');
            do_settings_sections('webexpert-skroutz-smart-cart-group');
            ?>

            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_unique_id"><?php _e('Unique ID','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td>
                        <select id="webexpert_skroutz_smart_cart_unique_id" name="webexpert_skroutz_smart_cart_unique_id">
                            <option value="sku" <?php echo get_option('webexpert_skroutz_smart_cart_unique_id','sku')=='sku' ? 'selected' : '';?>><?php _e('SKU','webexpert-woocommerce-skroutz-smart-cart');?></option>
                            <option value="id" <?php echo get_option('webexpert_skroutz_smart_cart_unique_id','sku')=='id' ? 'selected' : '';?>><?php _e('ID','webexpert-woocommerce-skroutz-smart-cart');?></option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_prefered_payment_gateway"><?php _e('Payment Gateway','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td>
                        <select id="webexpert_skroutz_smart_cart_prefered_payment_gateway" name="webexpert_skroutz_smart_cart_prefered_payment_gateway" value="<?php echo esc_attr( get_option('webexpert_skroutz_smart_cart_sender') ); ?>">
                            <?php foreach ( WC()->payment_gateways->get_available_payment_gateways() as $method ) { ?>
                                <option value="<?php echo $method->id;?>" <?php echo get_option('webexpert_skroutz_smart_cart_prefered_payment_gateway',null)==$method->id ? 'selected' : '';?>><?php echo $method->get_method_title();?></option>
                            <?php } ?>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_prefered_shipping_method"><?php _e('Shipping Method','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td>
	                    <?php
	                    $methods=[];
	                    $zone = new \WC_Shipping_Zone( 0 );
	                    foreach ( $zone->get_shipping_methods() as $shipping_method ) {
		                    $id=$shipping_method->id;
		                    $id.=!empty($shipping_method->get_instance_id()) ? ':'.$shipping_method->get_instance_id() : '';
		                    $methods[$id]=$shipping_method->get_method_title();
	                    }

	                    $zones = WC_Shipping_Zones::get_zones();
	                    foreach ( $zones as $zone ) {
		                    $zone = new \WC_Shipping_Zone( $zone['id'] );
		                    foreach ( $zone->get_shipping_methods() as $shipping_method ) {
			                    $id=$shipping_method->id;
			                    $id.=!empty($shipping_method->get_instance_id()) ? ':'.$shipping_method->get_instance_id() : '';
			                    $methods[$id]=$shipping_method->get_title();
		                    }
	                    }?>
                        <select id="webexpert_skroutz_smart_cart_prefered_shipping_method" name="webexpert_skroutz_smart_cart_prefered_shipping_method">
                            <?php foreach ( $methods as $k=>$method ) { ?>
                                <option value="<?php echo $k;?>" <?php echo get_option('webexpert_skroutz_smart_cart_prefered_shipping_method',null)==$k ? 'selected' : '';?>><?php echo $method;?></option>
                            <?php } ?>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_user_id"><?php _e('User ID','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td>
                        <select id="webexpert_skroutz_smart_cart_user_id" name="webexpert_skroutz_smart_cart_user_id">
                            <option value="-1" <?php echo get_option('webexpert_skroutz_smart_cart_user_id',-1)==-1 ? 'selected' : '';?>><?php _e('As a Guest','webexpert-woocommerce-skroutz-smart-cart');?></option>
                            <?php foreach ( get_users() as $user ) { ?>
                                <option value="<?php echo $user->ID;?>" <?php echo get_option('webexpert_skroutz_smart_cart_user_id',-1)==$user->ID ? 'selected' : '';?>><?php echo $user->display_name;?></option>
                            <?php } ?>
                        </select>
                        <p class="description"><?php _e('You can set up a user for all smart cart orders.','webexpert-woocommerce-skroutz-smart-cart');?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_billing_email"><?php _e('Billing Email','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td><input type="text" id="webexpert_skroutz_smart_cart_billing_email" name="webexpert_skroutz_smart_cart_billing_email" value="<?php echo esc_attr( get_option('webexpert_skroutz_smart_cart_billing_email') ); ?>" />
                        <p class="description"><?php _e('You can set a simple email address or wildcard addresses using {customer}.','webexpert-woocommerce-skroutz-smart-cart');?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_variation_attributes"><?php _e('Variation attributes','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td>
                        <select id="webexpert_skroutz_smart_cart_variation_attributes" name="webexpert_skroutz_smart_cart_variation_attributes[]" multiple>
                            <optgroup label="<?php _e('Choose attributes','webexpert-skroutz-xml-feed');?>">
			                    <?php foreach ($attribute_taxonomies as $atr) { ?>
                                    <option value="<?php echo $atr->attribute_name;?>"  <?php echo ((is_string($variation_attributes) && $variation_attributes==$atr->attribute_name) || (is_array($variation_attributes) && in_array($atr->attribute_name,$variation_attributes)) ? 'selected' : '' );?> ><?php echo $atr->attribute_label; ?></option>
			                    <?php } ?>
                            </optgroup>
                            <optgroup label="<?php _e('or taxonomies','webexpert-skroutz-xml-feed');?>">
			                    <?php foreach ($custom_taxonomies as $atr) { ?>
                                    <option value="<?php echo $atr->name;?>"  <?php echo ((is_string($variation_attributes) && $variation_attributes==$atr->name) || (is_array($variation_attributes) && in_array($atr->name,$variation_attributes)) ? 'selected' : '' );?> ><?php echo $atr->label; ?></option>
			                    <?php } ?>
                            </optgroup>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_api_token"><?php _e('API token','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td><input type="text" id="webexpert_skroutz_smart_cart_api_token" name="webexpert_skroutz_smart_cart_api_token" value="<?php echo esc_attr( get_option('webexpert_skroutz_smart_cart_api_token') ); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_manage_orders"><?php _e('Manage Orders','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td><label><input type="checkbox" value="yes" name="webexpert_skroutz_smart_cart_manage_orders" <?php echo (get_option('webexpert_skroutz_smart_cart_manage_orders',null)=='yes' ? 'checked="checked"' : ''); ?>> <?php _e('Accept new orders','webexpert-woocommerce-skroutz-smart-cart');?></label>
                        <p class="description"><?php _e('Enable this option if you want to accept new orders from Skroutz Smart cart via WooCommerce.<br>To accept an order, change status from On-hold to Processing or use Metabox.<br>To refuse an order, change status from On-hold to Cancelled or use Metabox.','webexpert-woocommerce-skroutz-smart-cart')?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_auto_accept_orders"><?php _e('Auto accept','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td><label><input type="checkbox" value="yes" name="webexpert_skroutz_smart_cart_auto_accept_orders" <?php echo (get_option('webexpert_skroutz_smart_cart_auto_accept_orders',null)=='yes' ? 'checked="checked"' : ''); ?>> <?php _e('Auto accept','webexpert-woocommerce-skroutz-smart-cart');?></label>
                        <p class="description"><?php _e('This option will auto accept any orders from Skroutz Smart Cart and picks up the chosen pickup window option','webexpert-woocommerce-skroutz-smart-cart')?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_auto_accept_orders_pickup_window"><?php _e('Auto accept pickup window','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td><select id="webexpert_skroutz_smart_cart_auto_accept_orders_pickup_window" name="webexpert_skroutz_smart_cart_auto_accept_orders_pickup_window">
                            <option value="first_pickup_window" <?php echo (get_option('webexpert_skroutz_smart_cart_auto_accept_orders_pickup_window',null)=='first_pickup_window' ? 'selected="selected"' : ''); ?>> <?php _e('First pickup window','webexpert-woocommerce-skroutz-smart-cart');?></option>
                            <option value="last_pickup_window" <?php echo (get_option('webexpert_skroutz_smart_cart_auto_accept_orders_pickup_window',null)=='last_pickup_window' ? 'selected="selected"' : ''); ?>> <?php _e('Last pickup window','webexpert-woocommerce-skroutz-smart-cart');?></option>
                        </select>
                        <p class="description"><?php _e('Choose the desired pickup window on auto accept orders','webexpert-woocommerce-skroutz-smart-cart')?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label class="screen-reader-text" for="webexpert_skroutz_smart_cart_special_id"><?php _e('Color ID/Parent ID (where applicable)','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td><label><input type="checkbox" value="yes" name="webexpert_skroutz_smart_cart_special_id" <?php echo (get_option('webexpert_skroutz_smart_cart_special_id','yes')=='yes' ? 'checked="checked"' : ''); ?>> <?php _e('Color ID/Parent ID (where applicable)','webexpert-woocommerce-skroutz-smart-cart');?></label>
                        <p class="description"><?php _e('Activate color ID in combination with parent product ID in variations, where applicable.','webexpert-woocommerce-skroutz-smart-cart')?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_debug"><?php _e('Log','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td><label><input type="checkbox" value="yes" name="webexpert_skroutz_smart_cart_debug" <?php echo (get_option('webexpert_skroutz_smart_cart_debug','yes')=='yes' ? 'checked="checked"' : ''); ?>> <?php _e('Log requests','webexpert-woocommerce-skroutz-smart-cart');?></label>
                        <p class="description"><?php _e('If enabled, all log requests from Skroutz.gr smart cart will be logged at ','webexpert-woocommerce-skroutz-smart-cart')?> <code><?php echo wp_upload_dir()['basedir'];?>/wc-logs/smart-cart.log</code></p>
                    </td>
                </tr>
            </table>
                <h2><?php _e('License','webexpert-woocommerce-skroutz-smart-cart');?></h2>
                <table class="form-table">
                    <tr valign="top">
                        <th scope="row"><label for="webexpert_skroutz_smart_cart_email"><?php _e('Email','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                        <td><input type="text" id="webexpert_skroutz_smart_cart_email" name="webexpert_skroutz_smart_cart_email" value="<?php echo esc_attr( get_option('webexpert_skroutz_smart_cart_email') ); ?>" /></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><label for="webexpert_skroutz_smart_cart_license_key"><?php _e('License Key','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                        <td><input type="text" id="webexpert_skroutz_smart_cart_license_key" name="webexpert_skroutz_smart_cart_license_key" value="<?php echo esc_attr( get_option('webexpert_skroutz_smart_cart_license_key') ); ?>" /></td>
                    </tr>
                </table>
                <?php submit_button();  ?>
                <input type="hidden" name="" value="<?php echo $_SERVER['HTTP_HOST'];?>">
            </form>

            <h2><?php _e('Debug','webexpert-woocommerce-skroutz-smart-cart');?></h2>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><label for="webexpert_skroutz_smart_cart_grab_order_id"><?php _e('Fetch order','webexpert-woocommerce-skroutz-smart-cart');?></label></th>
                    <td><input type="text" placeholder="<?php _e('XXXXXX-XXXXXX','webexpert-woocommerce-skroutz-smart-cart');?>" id="webexpert_skroutz_smart_cart_grab_order_id" name="webexpert_skroutz_smart_cart_grab_order_id" value="" />
                    <input type="button" data-success="<?php _e('Order fetched with ID:','webexpert-woocommerce-skroutz-smart-cart');?>" data-fail="<?php _e('Failed to fetch order','webexpert-woocommerce-skroutz-smart-cart');?>" class="button" id="webexpert_skroutz_smart_cart_grab_order" name="webexpert_skroutz_smart_cart_grab_order" value="<?php _e('Fetch','webexpert-woocommerce-skroutz-smart-cart');?>" />
                    </td>
                </tr>
            </table>
    </div>
    <?php
}


add_filter('plugin_action_links', 'smart_cart_plugin_action_links', 10, 2);

function smart_cart_plugin_action_links($links, $file)
{
	static $this_plugin;
	if (!$this_plugin) {
		$this_plugin = plugin_basename(__FILE__);
	}
	if ($file == $this_plugin) {
		$settings_link = '<a href="' . admin_url("admin.php?page=skroutz-smart-cart").'">'.__('Settings').'</a>';
		$support_link = '<a target="_blank" href="http://support.webexpert.gr">'.__('Support').'</a>';
		array_unshift($links, $settings_link, $support_link);
	}
	return $links;
}

function activate_webexpert_woocommerce_skroutz_smart_cart() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-webexpert-woocommerce-skroutz-smart-cart-activator.php';
	Webexpert_Woocommerce_Skroutz_Smart_Cart_Activator::activate();
}
function deactivate_webexpert_woocommerce_skroutz_smart_cart() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-webexpert-woocommerce-skroutz-smart-cart-deactivator.php';
	Webexpert_Woocommerce_Skroutz_Smart_Cart_Deactivator::deactivate();
}
register_activation_hook( __FILE__, 'activate_webexpert_woocommerce_skroutz_smart_cart' );
register_deactivation_hook( __FILE__, 'deactivate_webexpert_woocommerce_skroutz_smart_cart' );
require plugin_dir_path( __FILE__ ) . 'includes/class-webexpert-woocommerce-skroutz-smart-cart.php';
function run_webexpert_woocommerce_skroutz_smart_cart() {
	$plugin = new Webexpert_Woocommerce_Skroutz_Smart_Cart();
	$plugin->run();
}
run_webexpert_woocommerce_skroutz_smart_cart();
