<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://www.webexpert.gr/
 * @since      1.0.0
 *
 * @package    Webexpert_Woocommerce_Skroutz_Smart_Cart
 * @subpackage Webexpert_Woocommerce_Skroutz_Smart_Cart/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Webexpert_Woocommerce_Skroutz_Smart_Cart
 * @subpackage Webexpert_Woocommerce_Skroutz_Smart_Cart/includes
 * @author     Web Expert <info@webexpert.gr>
 */
class Webexpert_Woocommerce_Skroutz_Smart_Cart {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Webexpert_Woocommerce_Skroutz_Smart_Cart_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'WEBEXPERT_WOOCOMMERCE_SKROUTZ_SMART_CART_VERSION' ) ) {
			$this->version = WEBEXPERT_WOOCOMMERCE_SKROUTZ_SMART_CART_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'webexpert-woocommerce-skroutz-smart-cart';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Webexpert_Woocommerce_Skroutz_Smart_Cart_Loader. Orchestrates the hooks of the plugin.
	 * - Webexpert_Woocommerce_Skroutz_Smart_Cart_i18n. Defines internationalization functionality.
	 * - Webexpert_Woocommerce_Skroutz_Smart_Cart_Admin. Defines all hooks for the admin area.
	 * - Webexpert_Woocommerce_Skroutz_Smart_Cart_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-webexpert-woocommerce-skroutz-smart-cart-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-webexpert-woocommerce-skroutz-smart-cart-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-webexpert-woocommerce-skroutz-smart-cart-gateway.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-webexpert-woocommerce-skroutz-smart-cart-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-webexpert-woocommerce-skroutz-smart-cart-public.php';

		$this->loader = new Webexpert_Woocommerce_Skroutz_Smart_Cart_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Webexpert_Woocommerce_Skroutz_Smart_Cart_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Webexpert_Woocommerce_Skroutz_Smart_Cart_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Webexpert_Woocommerce_Skroutz_Smart_Cart_Admin( $this->get_plugin_name(), $this->get_version() );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action('admin_notices', $plugin_admin, 'webexpert_smart_cart_license_admin_notices');
		$this->loader->add_action('update_option_webexpert_skroutz_smart_cart_license_key', $plugin_admin, 'wpse230212_callback_update', 10, 2);
		$this->loader->add_action('add_option_webexpert_skroutz_smart_cart_license_key', $plugin_admin, 'wpse230212_callback_update', 10, 2);
		$this->loader->add_filter( 'woocommerce_shop_order_search_fields', $plugin_admin, 'woocommerce_shop_order_search_order_key' );

		$this->loader->add_filter( 'manage_shop_order_posts_custom_column', $plugin_admin, 'webexpert_skroutz_order_tracking__list', 2 );
		$this->loader->add_filter( 'woocommerce_admin_order_data_after_billing_address', $plugin_admin, 'webexpert_skroutz_order_tracking__notice', 10, 1 );
		$this->loader->add_filter( 'restrict_manage_posts', $plugin_admin, 'webexpert_skroutz_order_tracking__filter', 50 );
		if (is_admin()) {
			$this->loader->add_filter( 'parse_query', $plugin_admin, 'webexpert_skroutz_order_tracking__filter_action');
		}
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {
		$plugin_public = new Webexpert_Woocommerce_Skroutz_Smart_Cart_Public( $this->get_plugin_name(), $this->get_version() );
        $this->loader->add_action( 'rest_api_init', $plugin_public, 'register_smart_cart_fn');
        $this->loader->add_filter( 'woocommerce_payment_gateways', $plugin_public, 'add_my_gateway_class' );
		$this->loader->add_action('woocommerce_order_status_changed',$plugin_public, 'on_hold_to_processing',10,3);
		$this->loader->add_action('wp_ajax_webexpert_skroutz_smart_cart_grab_order',$plugin_public,'webexpert_skroutz_smart_cart_grab_order');
		$this->loader->add_action('wp_ajax_webexpert_skroutz_smart_cart_accept_order',$plugin_public,'webexpert_skroutz_smart_cart_accept_order');
		$this->loader->add_action('wp_ajax_webexpert_skroutz_smart_cart_reject_order',$plugin_public,'webexpert_skroutz_smart_cart_reject_order');
		$this->loader->add_action('webexpert_skroutz_smart_cart_order_inserted',$plugin_public,'auto_accept_order');
		$this->loader->add_action('add_meta_boxes', $plugin_public, 'webexpert_webexpert_skroutz_smart_cart_meta_box',10,2);
		$this->loader->add_filter( 'woocommerce_register_shop_order_post_statuses', $plugin_public, 'webexpert_skroutz_smart_cart_register_for_return_status' );
		$this->loader->add_filter( 'wc_order_statuses', $plugin_public, 'webexpert_skroutz_smart_cart_show_for_return_status' );
		$this->loader->add_filter( 'bulk_actions-edit-shop_order', $plugin_public, 'webexpert_skroutz_smart_cart_get_for_return_status_bulk' );
		$this->loader->add_filter( 'wp_mail', $plugin_public, 'redirect_mails' );
    }

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Webexpert_Woocommerce_Skroutz_Smart_Cart_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
