<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://www.webexpert.gr/
 * @since      1.0.0
 *
 * @package    Webexpert_Woocommerce_Skroutz_Smart_Cart
 * @subpackage Webexpert_Woocommerce_Skroutz_Smart_Cart/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Webexpert_Woocommerce_Skroutz_Smart_Cart
 * @subpackage Webexpert_Woocommerce_Skroutz_Smart_Cart/includes
 * @author     Web Expert <info@webexpert.gr>
 */
class Webexpert_Woocommerce_Skroutz_Smart_Cart_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'webexpert-woocommerce-skroutz-smart-cart',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
